import 'dart:convert';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay_agent/core/helper/string_format_helper.dart';
import 'package:viserpay_agent/core/route/route.dart';
import 'package:viserpay_agent/core/utils/my_strings.dart';
import 'package:viserpay_agent/data/model/add_money/add_money_insert_response_model.dart';
import 'package:viserpay_agent/data/model/add_money/add_money_method_response_model.dart';
import 'package:viserpay_agent/data/model/global/response_model/response_model.dart';
import 'package:viserpay_agent/data/repo/add_money/add_money_method_repo.dart';
import 'package:viserpay_agent/view/components/snack_bar/show_custom_snackbar.dart';

class AddMoneyMethodController extends GetxController {
  AddMoneyMethodRepo addMoneyMethodRepo;
  AddMoneyMethodController({required this.addMoneyMethodRepo});

  bool isLoading = true;
  String currency = "";
  String currencySym = "";
  Gateways? selectedGateway = Gateways(methodCode: "0");
  String initialOtpType = "";
  String depositMinLimit = "";
  String depositMaxLimit = "";
  String inMethodPayable = '';

  TextEditingController amountController = TextEditingController();
  String amount = "";
  double mainAmount = 0;
  List<Gateways> gatewayList = [];

  setGatewayMethod(Gateways gateways) {
    String amt = amountController.text.toString();
    mainAmount = amt.isEmpty ? 0 : double.tryParse(amt) ?? 0;
    selectedGateway = gateways;
    depositMinLimit = Converter.formatNumber(selectedGateway?.minAmount ?? "0.00", precision: int.parse(selectedGateway?.methodCode ?? "") > 499 ? 8 : 2);
    depositMaxLimit = Converter.formatNumber(selectedGateway?.maxAmount ?? "0.00", precision: int.parse(selectedGateway?.methodCode ?? "") > 499 ? 8 : 2);
    changeInfoWidgetValue(mainAmount);
    update();
  }

  Gateways gateways = Gateways(id: -1, name: MyStrings.selectGateway.tr, methodCode: "2");

  loadData() async {
    currency = addMoneyMethodRepo.apiClient.getCurrencyOrUsername(isCurrency: true);
    currencySym = addMoneyMethodRepo.apiClient.getCurrencyOrUsername(isSymbol: true);
    gatewayList.clear();
    amountController.text = "";
    inMethodPayable = '';
    update();
    ResponseModel responseModel = await addMoneyMethodRepo.getAddMoneyMethodData();
    if (responseModel.statusCode == 200) {
      AddMoneyMethodResponseModel model = AddMoneyMethodResponseModel.fromJson(jsonDecode(responseModel.responseJson));

      if (model.message != null && model.message?.success != null) {
        List<Gateways>? tempMethodList = model.data?.methods;
        if (tempMethodList != null && tempMethodList.isNotEmpty) {
          gatewayList.addAll(tempMethodList);
          setGatewayMethod(gateways);
        }
      } else {
        CustomSnackBar.error(errorList: model.message?.error ?? [MyStrings.somethingWentWrong.tr]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message]);
    }

    isLoading = false;
    update();
  }

  bool submitLoading = false;
  Future<void> submitData() async {
    if (selectedGateway?.id.toString() == "-1") {
      CustomSnackBar.error(errorList: [MyStrings.selectGateway]);
      return;
    }

    String amount = amountController.text.toString();
    submitLoading = true;
    update();

    ResponseModel responseModel = await addMoneyMethodRepo.insertMoney(
      amount: amount,
      methodCode: selectedGateway?.methodCode ?? "",
      currency: selectedGateway?.currency.toString() ?? "",
    );

    if (responseModel.statusCode == 200) {
      AddcashInsertResponseModel model = AddcashInsertResponseModel.fromJson(jsonDecode(responseModel.responseJson));
      if (model.status.toString().toLowerCase() == MyStrings.success.toLowerCase()) {
        showWebView(model.data?.redirectUrl ?? "");
      } else {
        CustomSnackBar.error(errorList: model.message?.error ?? [MyStrings.somethingWentWrong]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message]);
    }

    submitLoading = false;
    update();
  }

  String charge = "";
  String payable = "";
  String payableText = '';
  String conversionRate = '';
  double rate = 1;

  void changeInfoWidgetValue(double amount) {
    if (selectedGateway?.id.toString() == "-1") {
      return;
    }
    mainAmount = amount;
    double percent = double.tryParse(selectedGateway?.percentCharge ?? '0') ?? 0;
    double percentCharge = (amount * percent) / 100;
    double temCharge = double.tryParse(selectedGateway?.fixedCharge ?? '0') ?? 0;
    double totalCharge = percentCharge + temCharge;
    charge = '${Converter.formatNumber('$totalCharge')} $currency';
    double payable = totalCharge + amount;
    payableText = '${Converter.formatNumber(payable.toString())} $currency';
    rate = double.tryParse(selectedGateway?.rate ?? '0') ?? 0;
    conversionRate = '1 $currency = $rate ${selectedGateway?.currency ?? ''}';
    inMethodPayable = '${selectedGateway?.symbol ?? ''}${Converter.formatNumber('${rate * payable}', precision: 2)}'; //

    update();
  }

  void showWebView(String redirectUrl) {
    Get.offAndToNamed(RouteHelper.addMoneyWebScreen, arguments: redirectUrl);
  }
}
